#include <stdio.h>
#include <FS.h>             // this needs to be first, or it all crashes and burns...
#include "zeushd_macro.h"
#include <WiFiManager.h> // https://github.com/tzapu/WiFiManager
#include <ESP8266WiFi.h>          // Include the Wi-Fi library
#include <ArduinoJson.h> // https://github.com/bblanchon/ArduinoJson
#include <BlynkSimpleEsp8266.h>
#include <Ticker.h>
#include <NTPClient.h>
#include <WiFiUdp.h>
#include <zeushd_version.h>
// #include <Pinger.h>
// extern "C"
// {
  // #include <lwip/icmp.h> // needed for icmp packet definitions
// }
#if (enRTC)
  #include "RTClib.h"
#endif

const uint8     FW_VERSION              = 51;
#if (enRTC)
  char*           ota_filename          = "zeushdrtc";
  char*           ota_filename_ter      = "zeushdrtc";
  const char*     fwUrlBase             = "http://hungdo0993.duckdns.org:8080/zeushd/blynk/rtc/";
#else
  char*           ota_filename          = "zeushd";
  char*           ota_filename_ter      = "zeushd";
  const char*     fwUrlBase             = "http://hungdo0993.duckdns.org:8080/zeushd/blynk/nonrtc/";
#endif
char            blynk_token[33]         = "";
char            blynk_token_ter[33]     = "";
char            blynk_server[32]        = "zeushd.duckdns.org";
char            blynk_server_ter[32]    = "zeushd.duckdns.org";
String          ssidWiFi                = "";
String          passWiFi                = "";
boolean         flgAntiNoise            = false;
boolean         flgAntiNoise_ter        = false;
boolean         flgBootState            = false;
boolean         flgBootState_ter        = false;
boolean         flgMstMode              = true;
boolean         flgMstMode_ter          = true;
boolean         flgLanguageChange       = false;
boolean         flgSettingChange        = false;
boolean         flgAppConnected         = false;
boolean         flgAutoEnable           = false;
boolean         PCinc[noChannel]        = {false, false, false, false, false, false};
boolean         flgListChange           = false;
boolean         flgRTCSync              = false;
boolean         flgClientConnected      = false;
boolean         flgServer               = false;
boolean         flgServer_ter           = false;
boolean         flgBlynkAttached        = false;
boolean         flgReconnectBlynk       = false;
boolean         flgReset                = false;
boolean         flgBlynkSetup           = false;
boolean         flgScheduleUpdate       = false;
uint8           cntReset                = 0;
uint8           cntListChange           = 0;
uint8           lang                    = vi;
uint8           lang_ter                = vi;
uint8           language_cnt            = 0;
uint8           chkFWbutton             = 0;
uint8           cntBlynkConnect         = 0;
uint8           cntBlynkDisonnect       = cntBlynkDisconnect_TO;
uint8           model                   = 2;
uint8           model_ter               = 2;
uint8           Mac_Address[6]          = {0, 0, 0, 0, 0, 0};
uint8           idxTerminalMax          = 0;
uint8           eeplength               = 0;
uint8           stMode                  = 0;
uint8           Pin[7]                  = {255, 255, 255, 255, 255, 255, 255};
uint8           stTicker                = 0;
uint8           ledMasterVal[noChannel] = {0, 0, 0, 0, 0, 0};
uint16          noise_calib             = 50;
uint16          noise_calib_ter         = 50;
uint16          ledTopVal[noChannel]    = {0, 0, 0, 0, 0, 0};
uint16          dPC[noChannel]          = {0, 0, 0, 0, 0, 0};
uint16          cntAuto                 = 0;
uint16          ledVal[noChannel]       = {0, 0, 0, 0, 0, 0};
uint16          ledOldVal[noChannel]    = {0, 0, 0, 0, 0, 0};
uint16          ledSlaveVal[noChannel]  = {0, 0, 0, 0, 0, 0};
uint16          ledSendVal[noChannel]   = {0, 0, 0, 0, 0, 0};
uint32          ledAutoVal[noChannel]   = {0, 0, 0, 0, 0, 0};
Scheduling      scheduling[20];
B_Buffer        blynkBuffer;

WiFiEventHandler wifiConnectHandler;
WiFiEventHandler wifiDisconnectHandler;
Ticker ledStatusTimer;
Ticker wifiReconnectTimer;
Ticker blynkReconnectTimer;
WiFiUDP ntpUDP;
NTPClient timeClient(ntpUDP, "pool.ntp.org", 25200, 60000);
WiFiManager wm;
BlynkTimer mainTimer_1s;
BlynkTimer mainTimer_20ms;
WidgetTerminal terminal(ter);
WiFiManagerParameter custom_field; // global param ( for non blocking w params )
WiFiManagerParameter custom_model;
WiFiManagerParameter custom_anti;
WiFiManagerParameter custom_blynk_token("blynk_token_param", "Blynk Token", blynk_token, 33);
// WiFiManagerParameter custom_blynk_server("blynk_server_param", "Blynk Server", blynk_server, 32);
ESP8266WebServer server(80);
#if (enRTC)
  RTC_DS1307 rtc;
#endif
void ledStatus() {
  //toggle state
  digitalWrite(LED, !digitalRead(LED));       // set pin to the opposite state
}

uint32 TimetoSec (uint8 hour, uint8 min, uint8 sec) {
  return hour * 3600 + min * 60 + sec;
}

String DigitsTime(uint8 digits) {
  if (digits < 10) {
    return "0" + String(digits);
  }
  else
  {
    return String(digits);
  }
}

String DigitsNo(uint8 digits, boolean selected) {
  return ((selected ? ">": "|") + ((digits < 10) ? (" "+ String(digits)):(String(digits))));
}

String DigitsPC(uint8 digits) {
  if (digits < 10) {
    return "  " + String(digits) + "%";
  }
  else if (digits < 100) {
    return " " + String(digits) + "%";
  } else {
    return String(digits) + "%";
  }
}

String DigitsPCnonUnit(uint8 digits) {
  if (digits < 10)  {
    return "  " + String(digits);
  } else if (digits < 100) {
    return " " + String(digits);
  } else {
    return String(digits);
  }
}

void writeTerminal() {
  String str;
  uint8 idxStt = 0;
  chkFWbutton = 0;
  terminal.clear();
  terminal.print(F("|  | Time|"));
  switch(model) {
    case 3:
      terminal.println(F("  Blue  |  White |   UV   |"));
    break;
    case 4:
      terminal.println(F(" BL | WH | UV | R  |"));
    break;
    case 5:
      terminal.println(F(" B | RB| W | U | RG|"));
    break;
    case 6:
      terminal.println(F(" B | RB| W | U | R | G |"));
    break;
    case 2:
    default:
      terminal.println(F("  Blue  |  White |"));
    break;
  }
  // terminal.flush();
  for (idxStt = 0; idxStt < 20; idxStt++) {
    if (scheduling[idxStt].hour == 24) {
      idxTerminalMax = idxStt;
      switch(model) {
        case 3:
          str = DigitsNo(idxStt + 1, blynkBuffer.stt == idxStt) + "|--:--|  ---%  |  ---%  |  ---%  |";
        break;
        case 4:
          str = DigitsNo(idxStt + 1, blynkBuffer.stt == idxStt) + "|--:--|---%|---%|---%|---%|";
        break;
        case 5:
          str = DigitsNo(idxStt + 1, blynkBuffer.stt == idxStt) + "|--:--|---|---|---|---|---|";
        break;
        case 6:
          str = DigitsNo(idxStt + 1, blynkBuffer.stt == idxStt) + "|--:--|---|---|---|---|---|---|";
        break;
        case 2:
        default:
          str = DigitsNo(idxStt + 1, blynkBuffer.stt == idxStt) + "|--:--|  ---%  |  ---%  |";
        break;
      }
      terminal.println(str);
      break;
    } else {
      if (idxStt == 19) {
        idxTerminalMax = 20;
      }
      switch(model) {
        case 3:
          str = DigitsNo(idxStt + 1, blynkBuffer.stt == idxStt) + "|" + DigitsTime(scheduling[idxStt].hour) + ":" + DigitsTime(scheduling[idxStt].minute) + "|  " + DigitsPC(scheduling[idxStt].channel[Blue]) + "  |  " + DigitsPC(scheduling[idxStt].channel[White]) + "  |  " + DigitsPC(scheduling[idxStt].channel[UV]) + "  |";
        break;
        case 4:
          str = DigitsNo(idxStt + 1, blynkBuffer.stt == idxStt) + "|" + DigitsTime(scheduling[idxStt].hour) + ":" + DigitsTime(scheduling[idxStt].minute) + "|" + DigitsPC(scheduling[idxStt].channel[Blue]) + "|" + DigitsPC(scheduling[idxStt].channel[White]) + "|" + DigitsPC(scheduling[idxStt].channel[UV]) + "|" + DigitsPC(scheduling[idxStt].channel[Red]) + "|";
        break;
        case 5:
          str = DigitsNo(idxStt + 1, blynkBuffer.stt == idxStt) + "|" + DigitsTime(scheduling[idxStt].hour) + ":" + DigitsTime(scheduling[idxStt].minute) + "|" + DigitsPCnonUnit(scheduling[idxStt].channel[Blue]) + "|" + DigitsPCnonUnit(scheduling[idxStt].channel[RoyalBlue]) + "|" + DigitsPCnonUnit(scheduling[idxStt].channel[White]) + "|" + DigitsPCnonUnit(scheduling[idxStt].channel[UV]) + "|" + DigitsPCnonUnit(scheduling[idxStt].channel[Red])+ "|";
        break;
        case 6:
          str = DigitsNo(idxStt + 1, blynkBuffer.stt == idxStt) + "|" + DigitsTime(scheduling[idxStt].hour) + ":" + DigitsTime(scheduling[idxStt].minute) + "|" + DigitsPCnonUnit(scheduling[idxStt].channel[Blue]) + "|" + DigitsPCnonUnit(scheduling[idxStt].channel[RoyalBlue]) + "|" + DigitsPCnonUnit(scheduling[idxStt].channel[White]) + "|" + DigitsPCnonUnit(scheduling[idxStt].channel[UV]) + "|" + DigitsPCnonUnit(scheduling[idxStt].channel[Red])+ "|" + DigitsPCnonUnit(scheduling[idxStt].channel[Green])+ "|";
        break;
        case 2:
        default:
          str = DigitsNo(idxStt + 1, blynkBuffer.stt == idxStt) + "|" + DigitsTime(scheduling[idxStt].hour) + ":" + DigitsTime(scheduling[idxStt].minute) + "|  " + DigitsPC(scheduling[idxStt].channel[Blue]) + "  |  " + DigitsPC(scheduling[idxStt].channel[White]) + "  |";
        break;
      }
      terminal.println(str);
    }
  }
  terminal.flush();
  if (idxTerminalMax == 20) {
    switch(lang) {
      case en:
        str = (blynkBuffer.stt == 20) ? "> Delete all" : "Delete all";
        break;
      case vi:
      default:
        str = (blynkBuffer.stt == 20) ? "> Xóa tất cả" : "Xóa tất cả";
        break;
    }
    terminal.println(str);
    terminal.flush();
  }
}

void checkForUpdates() {
  WiFiClient client;
  String fwURL = String(fwUrlBase);
  String str;
  fwURL.concat(String(ota_filename));
  String fwVersionURL = fwURL;
  fwVersionURL.concat( ".version" );
  HTTPClient httpClient;
  httpClient.begin(client, fwVersionURL );
  int httpCode = httpClient.GET();
  if( httpCode == 200 )  {
    String newFWVersion = httpClient.getString();
    int newVersion = newFWVersion.toInt();
    #if (SERIAL_DEBUG)
      Serial.print("Get Version: ");
      Serial.println(newVersion);
    #endif
    if (String(ota_filename) == String("test")) {
      if (flgMstMode) {
        terminal.clear();
        switch (lang) {
          case en:
            str = "Updating to lastest version: 1." + String(newVersion) +".0";
            break;
          case vi:
          default:
            str = "Đang cập nhật lên phần mềm: 1." + String(newVersion) +".0";
            break;
        } 
        terminal.println(str);
        terminal.flush();
      }
      String fwImageURL = fwURL;
      fwImageURL.concat( ".bin" );
      ESPhttpUpdate.update(client, fwImageURL );
    } else {
      #if (SERIAL_DEBUG)
        Serial.println("Checking Version...");
      #endif
      switch (chkFWbutton) {
        case 0:
          if (newVersion > FW_VERSION) {
            #if (SERIAL_DEBUG)
              Serial.println("New Version...");
            #endif
            if (flgMstMode) {
              terminal.clear();
              switch (lang) {
                case en:
                  str = "Current version: 1." + String(FW_VERSION) + ".0\nNew update version: 1." + String(newVersion) + ".0\n\nPress Update to Submit.\nPress another keys to Back.";
                  terminal.println(str);
                  terminal.flush();
                  break;
                case vi:
                default:
                  str = "Phiên bản hiện tại: 1." + String(FW_VERSION) + ".0\nPhiên bản cập nhật mới: 1." + String(newVersion) + ".0\n\nBấm Cập nhật để xác nhận.";
                  terminal.println(str);
                  terminal.flush();
                  terminal.println(F("Bấm nút bất kì để quay lại."));
                  terminal.flush();
                  break;
              }
            }
            chkFWbutton = 1;
          } else {
            #if (SERIAL_DEBUG)
              Serial.println("Old Version...");
            #endif
            if (flgMstMode) {
              terminal.clear();
              if(lang == vi) {
                str = "Phiên bản hiện tại: 1." + String(FW_VERSION) + ".0\nKhông có phiên bản cập nhật mới.\n\nBấm nút bất kì để quay lại.";
              }
              else if (lang == en) {
                str = "Current version: 1." + String(FW_VERSION) + ".0\nNo new update.\n\nPress any keys to Back.";
              }
              terminal.println(str);
              terminal.flush();
            }
            chkFWbutton = 2;
          }
          break;
        case 1:
          #if (SERIAL_DEBUG)
            Serial.print( "Current firmware version: " );
            Serial.println( FW_VERSION );
            Serial.print( "Available firmware version: " );
            Serial.println( newFWVersion );
          #endif
          if( newVersion > FW_VERSION ) {
            if (flgMstMode && Blynk.connected()) {
              Blynk.virtualWrite (V106, 1);
              terminal.clear();
              #if (SERIAL_DEBUG)
                Serial.println( "Updating..." );
              #endif
              switch (lang) {
                case en:
                  str = "Updating to lastest version: 1." + String(newVersion) +".0";
                  break;
                case vi:
                default:
                   str = "Đang cập nhật lên phần mềm: 1." + String(newVersion) +".0";
                  break;
              }
              terminal.println(str);
              terminal.flush();
            }
            String fwImageURL = fwURL;
            fwImageURL.concat( ".bin" );
            ESPhttpUpdate.update(client, fwImageURL );
          } else {
            #if (SERIAL_DEBUG)
              Serial.println( "Already on latest version" );
            #endif
          }
          break;
        case 2:
          if (flgMstMode && Blynk.connected()) {
            writeTerminal();
          }
          break;
        default:
          break;
      }
    }
  } else {
    if (flgMstMode && Blynk.connected()) {
      writeTerminal();
    }
    #if (SERIAL_DEBUG)
      Serial.print( "Firmware version check failed, got HTTP response code " );
      Serial.println( httpCode );
    #endif
    httpClient.end();
  }
}

void saveConfigCallback() {
  flgReset = true;
}

void saveParamCallback() {
  char mode_ms[2];
  char anti_check_c[2];
  #if (SERIAL_DEBUG)
    Serial.println("saving config");
  #endif
  DynamicJsonDocument json(1024);
  getParam("mode_ms_field").toCharArray(mode_ms,2);
  getParam("anti_check_field").toCharArray(anti_check_c,2);
  flgAntiNoise              = (strncmp(anti_check_c, "T", 1) == 0);
  flgMstMode                = atoi(mode_ms) == 1;
  json["language"]          = lang;
  json["blynk_token"]       = custom_blynk_token.getValue();
  json["blynk_server"]      = blynk_server;
  json["mode_ms"]           = flgMstMode;
  json["model"]             = model;
  json["flgAntiNoise"]      = flgAntiNoise;
  json["ota_filename"]      = ota_filename;
  json["flgBootState"]      = flgBootState;
  json["flgServer"]         = flgServer;
  strcpy(blynk_token, json["blynk_token"]);
  File configFile = SPIFFS.open("/config.json", "w");
  #if (SERIAL_DEBUG)
    if (!configFile) {
      Serial.println("failed to open config file for writing");
    }
    serializeJsonPretty(json, Serial);
  #endif
  serializeJson(json, configFile);
  configFile.close();
  wm.startWebPortal();
  flgReset = true;
}

void setupSpiffs() {
  //clean FS, for testing
  // SPIFFS.format();

  //read configuration from FS json
  #if (SERIAL_DEBUG)
    Serial.println("mounting FS...");
  #endif
  if (SPIFFS.begin()) {
    #if (SERIAL_DEBUG)
      Serial.println("mounted file system");
    #endif
    if (SPIFFS.exists("/config.json")) {
      #if (SERIAL_DEBUG)
      //file exists, reading and loading
        Serial.println("reading config file");
      #endif
      File configFile = SPIFFS.open("/config.json", "r");
      if (configFile) {
        #if (SERIAL_DEBUG)
          Serial.println("opened config file");
        #endif
        size_t size = configFile.size();
        // Allocate a buffer to store contents of the file.
        std::unique_ptr<char[]> buf(new char[size]);
        configFile.readBytes(buf.get(), size);
        DynamicJsonDocument json(1024);
        DeserializationError error = deserializeJson(json, buf.get());
        #if (SERIAL_DEBUG)
          serializeJson(json, Serial);
        #endif
        if (!error) {
          if (json.containsKey("blynk_token")) {
            strcpy(blynk_token, json["blynk_token"]);
            strcpy(blynk_token_ter, json["blynk_token"]);
            if (strlen(blynk_token) < 10) {
              strcpy(blynk_token, "hGnU2UUYSVcqixXhcF2wg7drnZrtzkrD");
            }
          }
          if (json.containsKey("ota_filename")) {
            strcpy(ota_filename, json["ota_filename"]);
            strcpy(ota_filename_ter, json["ota_filename"]);
          }
          if (json.containsKey("mode_ms")) {
            flgMstMode = json["mode_ms"];
          }
          if (json.containsKey("model")) {
            model = json["model"];
            model_ter = json["model"];
          }
          if (json.containsKey("flgAntiNoise")) {
            flgAntiNoise = json["flgAntiNoise"];
            flgAntiNoise_ter = json["flgAntiNoise"];
          }
          if (json.containsKey("language")) {
            lang = json["language"];
            lang_ter = json["language"];
          }
          if (json.containsKey("noise_calib")) {
            noise_calib = json["noise_calib"];
            noise_calib_ter = json["noise_calib"];
          }
          if (json.containsKey("flgBootState")) {
            flgBootState = json["flgBootState"];
            flgBootState_ter = json["flgBootState"];
          }
          if (json.containsKey("flgServer")) {
            flgServer = json["flgServer"];
            flgServer_ter = json["flgServer"];
            if (flgServer) {
              if (json.containsKey("blynk_server")) {
                strcpy(blynk_server, json["blynk_server"]);
                strcpy(blynk_server_ter, json["blynk_server"]);
                #if (SERIAL_DEBUG)
                  Serial.print("Connecting to server ");
                  Serial.println(blynk_server);
                #endif
              }
            }
            #if (SERIAL_DEBUG)
              else {
                  Serial.println();
                  Serial.println("Connecting to server ZeusHD");
              }
            #endif
          }
        } else {
          #if (SERIAL_DEBUG)
            Serial.println("failed to load json config");
          #endif
          return;
        }
      }
      configFile.close();
    }
  } else {
  #if (SERIAL_DEBUG)
    Serial.println("failed to mount FS");
  #endif
  }
  
  //end read
}

void setupScheduling() {
  if (flgMstMode){
    uint8 idxLed = 0;
    uint8 idxStt = 0;
    for (idxStt = 0; idxStt < 20; idxStt++) {
      for (idxLed = 0; idxLed < noChannel; idxLed++){
        scheduling[idxStt].channel[idxLed] = 0;
      }
      scheduling[idxStt].hour = 24;
      scheduling[idxStt].minute = 60;
    }
    #if (SERIAL_DEBUG)
      Serial.println("mounting Scheduling...");
    #endif
    if (SPIFFS.begin()) {
      #if (SERIAL_DEBUG)
        Serial.println("mounted Scheduling file ");
      #endif
      if (SPIFFS.exists("/schedule.json")) {
        #if (SERIAL_DEBUG)
        //file exists, reading and loading
          Serial.println("reading schedule file");
        #endif
        File scheduleFile = SPIFFS.open("/schedule.json", "r");
        if (scheduleFile) {
          #if (SERIAL_DEBUG)
            Serial.println("opened schedule file");
          #endif
          size_t size = scheduleFile.size();
          // Allocate a buffer to store contents of the file.
          std::unique_ptr<char[]> buf(new char[size]);
          scheduleFile.readBytes(buf.get(), size);
          DynamicJsonDocument json(3072);
          DeserializationError error = deserializeJson(json, buf.get());
          Serial.println(error.c_str());
          #if (SERIAL_DEBUG)
            serializeJson(json, Serial);
          #endif
          if (!error) {
            if (json.containsKey("schedule")) {
              for (idxStt = 0; idxStt < 20; idxStt++) {
                for (idxLed = 0; idxLed < noChannel; idxLed++) {
                  scheduling[idxStt].channel[idxLed] = json["schedule"][idxStt]["channel"][idxLed];
                }
                scheduling[idxStt].hour = json["schedule"][idxStt]["hour"];
                scheduling[idxStt].minute = json["schedule"][idxStt]["minute"];
                scheduling[idxStt].time = TimetoSec(scheduling[idxStt].hour, scheduling[idxStt].minute, 0);
                if (scheduling[idxStt].hour == 24) {
                  schedulingMaxIndex = idxStt - 1;
                }
              }
            }
          } else {
            #if (SERIAL_DEBUG)
              Serial.println("failed to load json config");
            #endif
            return;
          }
        }
        scheduleFile.close();
        flgAutoEnable = (scheduling[0].hour != 24);
      }
    } else {
    #if (SERIAL_DEBUG)
      Serial.println("failed to mount FS");
    #endif
    }
  }
}

void setupIOPin() {
  uint8 idxStt = 0;
  uint8 idxLed = 0;
  analogWriteRange(1000);
  switch(model) {
    case 6:
      Pin[Green] = 0;
    case 5:
      Pin[RoyalBlue] = 13;
    case 4:
      #if (enRTC)
        Pin[Red] = 1;
      #else
        Pin[Red] = 5;
      #endif
    case 3:
      #if (enRTC)
        Pin[UV] = 3;
      #else
        Pin[UV] = 4;
      #endif
    case 2:
    default:
      Pin[Blue] = 14;
      Pin[White] = 12;
      break;
  }
  Pin[FAN] = model >= 5 ? 16 : 13;
  analogWriteFreq(flgAntiNoise ? freqLed : 1000);
  for (idxLed = 0; idxLed< noChannel; idxLed++) {
    if (Pin[idxLed] != 255) {
      analogWrite(Pin[idxLed], flgBootState ? 1000 : 0);
    }
  }
  pinMode(Pin[FAN], OUTPUT);
  digitalWrite(Pin[FAN], flgBootState);
}

void updateScheduling() {
  uint8 idxLed = 0;
  uint8 idxStt = 0;
  DynamicJsonDocument json(3072);
  for (idxStt = 0; idxStt < 20; idxStt++) {
    for (idxLed = 0; idxLed < noChannel; idxLed++) {
      json["schedule"][idxStt]["channel"][idxLed] = scheduling[idxStt].channel[idxLed];
    }
    json["schedule"][idxStt]["hour"] = scheduling[idxStt].hour;
    json["schedule"][idxStt]["minute"] = scheduling[idxStt].minute;
  }
  File scheduleFile = SPIFFS.open("/schedule.json", "w");
  serializeJson(json, scheduleFile);
  scheduleFile.close();
  #if (SERIAL_DEBUG)
    Serial.println("Save Scheduling File...");
  #endif
  flgScheduleUpdate = false;
}

String getParam(String name) {
//read parameter from server, for customhmtl input
  String value;
  if(wm.server->hasArg(name)) {
    value = wm.server->arg(name);
  }
  return value;
}

void connectToWifi() {
  #if (SERIAL_DEBUG)
    Serial.println("Connecting to Wi-Fi...");
  #endif
  if (!flgClientConnected) {
    WiFi.begin(ssidWiFi.c_str(), passWiFi.c_str());
  }
}

void connectToBlynk() {
  flgBlynkAttached = true;
  if (cntBlynkConnect < cntBlynkConnect_TO) {
    if (!flgClientConnected) {
      #if (SERIAL_DEBUG)
        Serial.println("Connecting to Blynk...");
      #endif
      flgReconnectBlynk = true;
      cntBlynkConnect++;
    }
  } else {
    cntBlynkConnect = 0;
    WiFi.disconnect();
    flgBlynkAttached = false;
    blynkReconnectTimer.detach();
  }
}

void onWifiConnect(const WiFiEventStationModeGotIP& event) {
  (void) event;
  #if (SERIAL_DEBUG)
    Serial.print("Connected to Wi-Fi. IP address: "); Serial.println(WiFi.localIP());
  #endif
  if (stTicker != 1) {
    ledStatusTimer.attach(1, ledStatus);
    stTicker = 1;
  }
  wifiReconnectTimer.detach();
  blynkReconnectTimer.attach(10, connectToBlynk);
  connectToBlynk();
}

void onWifiDisconnect(const WiFiEventStationModeDisconnected& event) {
  (void) event;
  #if (SERIAL_DEBUG)
    Serial.println("Disconnected from Wi-Fi.");
  #endif
  if (stTicker != 2) {
    ledStatusTimer.attach(0.2, ledStatus);
    stTicker = 2;
  }
  wifiReconnectTimer.attach(10, connectToWifi);
  connectToWifi();
}

void setupDeviceWM() {
  char    SSID_name[23];
  WiFi.setAutoReconnect(true);
  WiFi.persistent(true);
  WiFi.mode(WIFI_AP_STA);
  WiFi.macAddress(Mac_Address);
  wifiConnectHandler = WiFi.onStationModeGotIP(onWifiConnect);
  wifiDisconnectHandler = WiFi.onStationModeDisconnected(onWifiDisconnect);
  sprintf(SSID_name, "Zeus HD - %02X%02X%02X%02X%02X%02X", Mac_Address[0], Mac_Address[1], Mac_Address[2], Mac_Address[3], Mac_Address[4], Mac_Address[5]);
  custom_blynk_token.setValue(blynk_token, 32);
  wm.addParameter(&custom_blynk_token);
  const char* custom_radio_str;
  const char* anti_check_str;
  if (flgMstMode) {
    custom_radio_str = "<p>Chế độ:</p>"
    "<input style='width: auto; margin: 0 10px 0 10px;' type='radio' name='mode_ms_field' value='1' checked>"
    "<label for='mode_ms_field'>Đèn chính</label><br>"
    "<input style='width: auto; margin: 10px 10px 0 10px;' type='radio' name='mode_ms_field' value='0'>"
    "<label for='mode_ms_field'>Đèn phụ</label><br>";
  } else {
    custom_radio_str = "<p>Chế độ:</p>"
    "<input style='width: auto; margin: 0 10px 0 10px;' type='radio' name='mode_ms_field' value='1'>"
    "<label for='mode_ms_field'>Đèn chính</label><br>"
    "<input style='width: auto; margin: 10px 10px 0 10px;' type='radio' name='mode_ms_field' value='0' checked>"
    "<label for='mode_ms_field'>Đèn phụ</label><br>";
  }
  if (flgAntiNoise) {
    anti_check_str = "<br><input style='width: auto;' type='checkbox' id='anti_check_field' name='anti_check_field' value='T' checked> <label for='anti_check_field'>Khử ồn cho đèn M029</label>";
  } else {
    anti_check_str = "<br><input style='width: auto;' type='checkbox' id='anti_check_field' name='anti_check_field' value='T'> <label for='anti_check_field'>Khử ồn cho đèn M029</label>";
  }
  new (&custom_field)WiFiManagerParameter(custom_radio_str); // custom html input
  wm.addParameter(&custom_field);
  new (&custom_anti) WiFiManagerParameter(anti_check_str);
  wm.addParameter(&custom_anti);
  wm.setSaveConfigCallback(saveConfigCallback);
  wm.setSaveParamsCallback(saveParamCallback);
  wm.setWiFiAutoReconnect(true);
  wm.setConfigPortalBlocking(false);
  std::vector<const char *> menu = {"wifi","updatezeushd","sep","restart","exit"};
  wm.setMenu(menu);
  wm.setClass("invert");
  wm.setConfigPortalTimeout(180);
  wm.setDebugOutput(SERIAL_DEBUG);
  // WiFi.softAP(SSID_name, "88888888");
  // wm.startWebPortal();
  // server.begin();
  wm.startConfigPortal(SSID_name, "88888888");
  // wm.autoConnect(SSID_name, "88888888");
  ssidWiFi = wm.getWiFiIsSaved() ? wm.getWiFiSSID(true) : "WifiHP";
  passWiFi = wm.getWiFiIsSaved() ? wm.getWiFiPass(true) : "hung147896325";
  connectToWifi();
}

void mainTask_1s() {
  boolean     flgSend             = false;
  uint8       idxLed              = 0;
  uint8       idxSlot             = 0;
  uint8       idxSttAuto          = 0;
  uint32      currentTime         = 0;
  if (flgReconnectBlynk) {
    if (!flgBlynkSetup) {
      Blynk.config(blynk_token,blynk_server,8080);
      flgBlynkSetup = true;
    }
    #if (SERIAL_DEBUG)
      Serial.println("Connecting to Blynk...");
    #endif
    Blynk.connect(3000);
    flgReconnectBlynk = false;
  }
  if (cntBlynkDisonnect < cntBlynkDisconnect_TO) {
    cntBlynkDisonnect ++;
  } else {
    cntBlynkDisonnect = 0;
    flgClientConnected = wifi_softap_get_station_num() > 0;
    #if (SERIAL_DEBUG)
    if (flgClientConnected) {
      Serial.println("Web connected");
    }
    #endif
    if (WiFi.isConnected()) {
      if (!Blynk.connected()) {
        if (!flgBlynkAttached) {
          if (stTicker != 1) {
            ledStatusTimer.attach(1, ledStatus);
            stTicker = 1;
          }
          blynkReconnectTimer.attach(10, connectToBlynk);
        }
      } else {
        stTicker = 0;
      }
    }
  }
  if (flgReset) {
    ESP.restart();
  }
  if (digitalRead(15)) {
    if (cntReset < 3) {
      cntReset++;
    } else {
      ESP.restart();
    }
  } else {
    cntReset = 0;
  }
  #if (enRTC)
  DateTime now = rtc.now();
  #endif
  if (WiFi.isConnected()) {
    timeClient.update();
    currentTime = TimetoSec(timeClient.getHours(), timeClient.getMinutes(), timeClient.getSeconds());
  #if (enRTC)
    if (timeClient.getMinutes() == 30 &&
        timeClient.getSeconds() == 0) {
      if (timeClient.getHours() != now.hour() || 
          timeClient.getMinutes() != now.minute()) {
        flgRTCSync = false;
      }
    }
    if (!flgRTCSync) {
      rtc.adjust(DateTime(2021, 1, 1, timeClient.getHours(), timeClient.getMinutes(), timeClient.getSeconds()));
      flgRTCSync = true;
    }
  } else {
    if (rtc.isrunning()) {
      currentTime = TimetoSec(now.hour(), now.minute(), now.second());
    }
  #endif
  }
  if (Blynk.connected()) {
    if(flgMstMode) {
      flgAutoEnable = (scheduling[0].hour != 24);
      if (language_cnt == 1) {
        language_cnt++;
      } else if (language_cnt == 2) {
        language_cnt = 0;
        writeTerminal();
      }
      if (stMode != modeAuto && flgAutoEnable) {
        if ((cntAuto < cntAutoTO) && (cntAuto > 0)) {
          cntAuto++;
        }
        else if (cntAuto == cntAutoTO) {
          stMode = modeAuto;
          Blynk.virtualWrite(btnMode, stMode);
          cntAuto = 0;
        }
      }
      idxSttAuto = blynkBuffer.stt;
      if  (flgListChange) {
        if (scheduling[idxSttAuto].hour != 24) {
          blynkBuffer.hour = scheduling[idxSttAuto].hour;
          blynkBuffer.minute = scheduling[idxSttAuto].minute;
        }
        for (idxLed = 0; idxLed < noChannel ; idxLed++) {
          if (Pin[idxLed] != 255) {
            if (scheduling[idxSttAuto].hour == 24) {
              blynkBuffer.channel[idxLed] = 0;
            } else {
              blynkBuffer.channel[idxLed] = scheduling[idxSttAuto].channel[idxLed];
            }
          }
        }
        flgListChange = false;
      }
      if (cntListChange == 2) {
        if (scheduling[idxSttAuto].hour != 24) {
          Blynk.virtualWrite(tiInput, int(TimetoSec(scheduling[idxSttAuto].hour, scheduling[idxSttAuto].minute, 0)), 0, "Asia/Ho_Chi_Minh","1",100);
        }
        for (idxLed = 0; idxLed < noChannel ; idxLed++) {
          if (Pin[idxLed] != 255) {
            if (scheduling[idxSttAuto].hour == 24) {
              if (stMode == modeManual) {
                ledVal[idxLed] = 0;
                flgSend = (ledSlaveVal[idxLed] != 0) | flgSend;
                if (ledSlaveVal[idxLed] != 0) {
                  ledSlaveVal[idxLed] = 0;
                  ledSendVal[idxLed] = 0;
                }
              }
              if (ledMasterVal[idxLed] != 0) {
                ledMasterVal[idxLed] = 0;
                Blynk.virtualWrite(idxLed, 0);
              }
            } else {
              if (stMode == modeManual) {
                ledVal[idxLed] = scheduling[idxSttAuto].channel[idxLed] * 10;
                flgSend = (ledVal[idxLed] != ledSlaveVal[idxLed]) | flgSend;
                if (ledVal[idxLed] != ledSlaveVal[idxLed])
                {
                  ledSlaveVal[idxLed] = ledVal[idxLed];
                  ledSendVal[idxLed] = ledSlaveVal[idxLed];
                }
              }
              if (ledMasterVal[idxLed] != scheduling[idxSttAuto].channel[idxLed]) {
                ledMasterVal[idxLed] = scheduling[idxSttAuto].channel[idxLed];
                Blynk.virtualWrite(idxLed, ledMasterVal[idxLed]);
              }
            }
          }
        }
        if (flgSend) {
          SlaveSent;
        }
        cntListChange = 0;
      }
      if(cntListChange == 1) {
        cntListChange++;
      }
    } else {
      Blynk.syncVirtual(SlaveBlynk);
    }
  }
  if (flgMstMode) {
    if (currentTime < firstTime || lastTime < currentTime) {
      for (idxLed = 0; idxLed < noChannel; idxLed++) {
        if (Pin[idxLed] != 255) {
          ledAutoVal[idxLed] = scheduling[schedulingMaxIndex].channel[idxColor] * 10000;
        }
      }
    } else {
      for (idxSlot = 0; idxSlot < schedulingMaxIndex; idxSlot++) {
        if (currentTime == baseTime) {
          for (idxLed = 0; idxLed < noChannel; idxLed++) {
            if (Pin[idxLed] != 255) {
              ledAutoVal[idxLed] = baseTime;
            }
          }
          break;
        } else if (baseTime < currentTime && currentTime < nextTime) {
          for (idxLed = 0; idxLed < noChannel; idxLed++) {
            if (Pin[idxLed] != 255) {
              if (pwmNext > pwmBase) {
                ledAutoVal[idxLed] = pwmBase + (((pwmNext - pwmBase) * (currentTime - baseTime)) / deltaTime);
              } else if (pwmNext < pwmBase) {
                ledAutoVal[idxLed] = pwmBase - (((pwmBase - pwmNext) * (currentTime - baseTime)) / deltaTime);
              } else {
                ledAutoVal[idxLed] = pwmBase;
              }
            }
          }
          break;
        }
      }
    }
    if (stMode == modeAuto) {
      flgSend = false;
      for (idxLed = 0; idxLed < noChannel ; idxLed++) {
        if (Pin[idxLed] != 255) {
          ledVal[idxLed] = (ledAutoVal[idxLed] / 1000);
          if (Blynk.connected()) {
            if (flgAppConnected) {
              if (ledMasterVal[idxLed] != uint8_t(ledAutoVal[idxLed] / 10000)) {
                ledMasterVal[idxLed] = uint8_t(ledAutoVal[idxLed] / 10000);
                Blynk.virtualWrite(idxLed, ledMasterVal[idxLed]);
              }
            }
            flgSend = (ledSlaveVal[idxLed] != ledVal[idxLed]) | flgSend;
            if (ledSlaveVal[idxLed] != ledVal[idxLed]) {
              ledSlaveVal[idxLed] = ledVal[idxLed];
              ledSendVal[idxLed] = ledSlaveVal[idxLed];
            }
          }
        }
      }
      if (flgSend) {
        SlaveSent;
      }
    }
  }
}

void mainTask_20ms() {
  boolean     flgFan              = false;
  uint8_t     idxLed              = 0;
  for (idxLed = 0; idxLed < noChannel; idxLed++) {
    if (Pin[idxLed] != 255) {
      if (ledOldVal[idxLed] != ledVal[idxLed]) {
        if (ledOldVal[idxLed] < ledVal[idxLed]) {
          ledOldVal[idxLed] += ((ledVal[idxLed] - ledOldVal[idxLed]) > 10) ? 10 : (ledVal[idxLed] - ledOldVal[idxLed]);
        } else if (ledOldVal[idxLed] > ledVal[idxLed]) {
          ledOldVal[idxLed] -= ((ledOldVal[idxLed] - ledVal[idxLed]) > 10) ? 10 : (ledOldVal[idxLed] - ledVal[idxLed]);
        }
        analogWrite(Pin[idxLed], ledOldVal[idxLed]);
      }
      flgFan = (ledOldVal[idxLed] != 0) | flgFan;
    }
  }
  digitalWrite(Pin[FAN], flgFan);
}

void setup() {
  #if (enRTC)
    rtc.begin();
  #endif
  pinMode(LED, OUTPUT);
  pinMode(15, INPUT);
  #if (SERIAL_DEBUG)
    Serial.begin(115200);
    Serial.println();
  #endif
  if (stTicker != 2) {
    ledStatusTimer.attach(0.2, ledStatus);
    stTicker = 2;
  }
  setupSpiffs();
  setupIOPin();
  setupDeviceWM();
  setupScheduling();
  mainTimer_1s.setInterval(1000, mainTask_1s);
  mainTimer_20ms.setInterval(20, mainTask_20ms);
  if (!flgBlynkSetup) {
    Blynk.config(blynk_token,blynk_server,8080);
    flgBlynkSetup = true;
  }
}

void appStartup(){
  String str_update = "Danh sách - 1.";
  uint8 idxLed = 0;
  terminal.clear();
  switch(lang) {
    case en:
      terminal.println("Starting Up...");
      terminal.println("Please wait for a moment");
      str_update = "Timer List - 1.";
      break;
    case vi:
    terminal.println("Đang khởi động...");
    terminal.println("Xin chờ trong vài giây");
    default:
      break;
  }
  terminal.flush();
  str_update = str_update + String(FW_VERSION) + ".0";
  Blynk.setProperty(ter, "label", str_update);
  Blynk.virtualWrite(languageInput, lang);
  Blynk.virtualWrite(noiseInput, flgAntiNoise?1:0);
  Blynk.syncVirtual(tiInput);
  if (!flgAppConnected) {
    Blynk.virtualWrite(btnMode, 4);
  } else {
    Blynk.virtualWrite(btnMode, stMode);
  }
  for (idxLed = 0; idxLed < noChannel; idxLed++) {
    if ((Pin[idxLed] != 255)) {
      Blynk.syncVirtual(idxLed);
    }
  }
  writeTerminal();
}

BLYNK_CONNECTED() {
  #if (SERIAL_DEBUG)
    Serial.println("Blynk connected...");
  #endif
  stTicker = 0;
  flgBlynkAttached = false;
  ledStatusTimer.detach();
  blynkReconnectTimer.detach();
  digitalWrite(LED, LOW);
  stMode = (flgAutoEnable) ? modeAuto : modeManual;
  if (flgMstMode) {
    appStartup();
  }
}
BLYNK_APP_CONNECTED() {
  flgAppConnected = true;
  Blynk.virtualWrite(btnMode, stMode);
}

BLYNK_APP_DISCONNECTED() {
  flgAppConnected = false;
  Blynk.virtualWrite(btnMode, 4);
}

BLYNK_WRITE_DEFAULT() {
  uint8 rqpin = byte(request.pin);
  if ((rqpin == Blue) ||
      (rqpin == RoyalBlue) ||
      (rqpin == White) ||
      (rqpin == UV) ||
      (rqpin == Red) ||
      (rqpin == Green)) {
    uint8 value = byte(param.asInt());
    #if (SERIAL_DEBUG)
      Serial.print("Channel: ");
      Serial.print(rqpin);
      Serial.print(" - Value: ");
      Serial.print(value);
      Serial.println("%");
    #endif
    if (flgMstMode) {
      blynkBuffer.channel[rqpin] = value;
      cntAuto = 1;
      if (flgAppConnected) {
        if ((stMode != modeManual && stMode != modeTimer)) {
          stMode = modeManual;
          Blynk.virtualWrite(btnMode, stMode);
        }
        if (stMode == modeManual) {
          ledVal[rqpin] = value * 10;
          ledMasterVal[rqpin] = value;
          if (ledVal[rqpin] != ledSlaveVal[rqpin]) {
            ledSlaveVal[rqpin] = ledVal[rqpin];
            ledSendVal[rqpin] = ledVal[rqpin];
            SlaveSent;
          }
        }
      }
    }
  }
}

BLYNK_WRITE(SlaveBlynk) {
  if (!flgMstMode) {
    uint8 idxLed;
    for (idxLed = 0; idxLed < noChannel ; idxLed++) {
      if ((Pin[idxLed] != 255)) {
        ledVal[idxLed] = param[idxLed].asInt();
      }
    }
  }
}

BLYNK_WRITE(tiInput) {
  if (flgMstMode) {
    TimeInputParam t(param);
    if (t.hasStartTime()) {
      blynkBuffer.hour = t.getStartHour();
      blynkBuffer.minute = t.getStartMinute();
    } else {
      blynkBuffer.hour = 24;
      blynkBuffer.minute = 60;
    }
  }
}

BLYNK_WRITE(btnUp) {
  if (param.asInt() == 1 && flgMstMode) {
    if (chkFWbutton == 0) {
      if (idxTerminalMax != 0) {
        if (blynkBuffer.stt != 0) {
          blynkBuffer.stt--;
        } else {
          blynkBuffer.stt = idxTerminalMax;
        }
        if (blynkBuffer.stt != idxTerminalMax) {
          cntListChange = 1;
          flgListChange = true;
        }
        cntAuto = 1;
        if (stMode == modeAuto) {
          stMode = modeTimer;
          Blynk.virtualWrite(btnMode, stMode);
        }
        writeTerminal();
      }
    }
  }
}

BLYNK_WRITE(btnDown) {
  if (param.asInt() == 1 && flgMstMode) {
    if (chkFWbutton == 0) {
      if (idxTerminalMax != 0) {
        if ((blynkBuffer.stt < idxTerminalMax)) {
          blynkBuffer.stt++;
        } else {
          blynkBuffer.stt = 0;
        }
        if (blynkBuffer.stt != idxTerminalMax) {
          cntListChange = 1;
          flgListChange = true;
        }
        cntAuto = 1;
        if (stMode == modeAuto) {
          stMode = modeTimer;
          Blynk.virtualWrite(btnMode, stMode);
        }
        writeTerminal();
      }
    }
  }
}

BLYNK_WRITE(btnAdd) {
  byte idx = 0;
  byte idxStt = 0;
  byte idxLed = 0;
  if (param.asInt() == 1 && flgMstMode) {
    // flgAutoEnable = (scheduling[0].hour != 24);
    if (chkFWbutton == 0 && idxTerminalMax != 20) {
      if (blynkBuffer.stt != idxTerminalMax) {
        for (idxStt = idxTerminalMax; idxStt > blynkBuffer.stt; idxStt--) {
          for (idxLed = 0; idxLed < noChannel; idxLed++) {
            scheduling[idxStt].channel[idxLed] = scheduling[idxStt-1].channel[idxLed];
          }
          scheduling[idxStt].hour = scheduling[idxStt-1].hour;
          scheduling[idxStt].minute = scheduling[idxStt-1].minute;
        }
        flgScheduleUpdate = true;
      }
      if (!((blynkBuffer.hour > 23) || 
            (blynkBuffer.minute > 59) || 
            (blynkBuffer.channel[Blue] > 100 && Pin[Blue]!= 255) || 
            (blynkBuffer.channel[RoyalBlue] > 100 && Pin[RoyalBlue]!= 255) || 
            (blynkBuffer.channel[White] > 100 && Pin[White]!= 255) || 
            (blynkBuffer.channel[UV] > 100 && Pin[UV]!= 255) || 
            (blynkBuffer.channel[Red] > 100 && Pin[Red]!= 255) || 
            (blynkBuffer.channel[Green] >100 && Pin[Green]!= 255))) {
        idx = blynkBuffer.stt * (noChannel + 2);
        for (idxLed = 0; idxLed < noChannel; idxLed++) {
          scheduling[blynkBuffer.stt].channel[idxLed] = blynkBuffer.channel[idxLed];
        }
        scheduling[blynkBuffer.stt].hour = blynkBuffer.hour;
        scheduling[blynkBuffer.stt].minute = blynkBuffer.minute;
        blynkBuffer.stt++;
        flgScheduleUpdate = true;
      }
    }
    writeTerminal();
  }
}

BLYNK_WRITE(btnModify) {
  byte idx = 0;
  byte idxLed = 0;
  if (param.asInt() == 1 && flgMstMode) {
    // flgAutoEnable = (scheduling[0].hour != 24);
    if (chkFWbutton == 0) {
      if (blynkBuffer.stt != idxTerminalMax) {
        if (!(  blynkBuffer.hour>23 || 
          blynkBuffer.minute>59 || 
          (blynkBuffer.channel[Blue]>100 && Pin[Blue]!= 255) || 
          (blynkBuffer.channel[RoyalBlue]>100 && Pin[RoyalBlue]!= 255) || 
          (blynkBuffer.channel[White]>100 && Pin[White]!= 255) || 
          (blynkBuffer.channel[UV]>100 && Pin[UV]!= 255) || 
          (blynkBuffer.channel[Red]>100 && Pin[Red]!= 255) || 
          (blynkBuffer.channel[Green]>100 && Pin[Green]!= 255))) {
          idx = blynkBuffer.stt * noChannel;
          for (idxLed = 0; idxLed < noChannel; idxLed++) {
            scheduling[blynkBuffer.stt].channel[idxLed] = blynkBuffer.channel[idxLed];
          }
          scheduling[blynkBuffer.stt].hour = blynkBuffer.hour;
          scheduling[blynkBuffer.stt].minute = blynkBuffer.minute;
          flgScheduleUpdate = true;
        }
      }
    }
    writeTerminal();
  }
}

BLYNK_WRITE(btnDel) {
  uint8 idx = 0;
  uint8 idxLed = 0;
  uint8 idxStt = 0;
  if (param.asInt() == 1 && flgMstMode) {
    // flgAutoEnable = (scheduling[0].hour != 24);
    if (chkFWbutton == 0) {
      if (idxTerminalMax != 0) {
        if (blynkBuffer.stt == idxTerminalMax) {
          for (idxStt = 0; idxStt < 20; idxStt++) {
            for (idxLed = 0; idxLed < noChannel; idxLed++) {
              scheduling[idxStt].channel[idxLed] = 0;
            }
            scheduling[idxStt].hour = 24;
            scheduling[idxStt].minute = 0;
          }
          updateScheduling();
          blynkBuffer.stt = 0;
        } else {
          idx = blynkBuffer.stt;
          for(idxStt = idx; idxStt < 20; idxStt++) {
            if (scheduling[idxStt].hour == 24) {
              break;
            } else {
              idx = idxLed * (noChannel + 2);
              for (idxLed = 0; idxLed < noChannel; idxLed++) {
                scheduling[idxStt].channel[idxLed] = scheduling[idxStt + 1].channel[idxLed];
              }
              scheduling[idxStt].hour = scheduling[idxStt + 1].hour;
              scheduling[idxStt].minute = scheduling[idxStt + 1].minute;
            }
          }
          if (idxTerminalMax == 1){
            updateScheduling();
          } else {
            flgScheduleUpdate = true;
          }
        }
        writeTerminal();
      }
    }
  }
}

BLYNK_WRITE(btnUpdate) {
  if (param.asInt() == 1) {
    checkForUpdates();
  }
}

BLYNK_WRITE(btnMode) {
  uint8 idxLed;
  stMode = byte(param.asInt());
  flgAppConnected = true;
  if (stMode == modeAuto) {
    if (!flgAutoEnable)
    {
      stMode = modeManual;
      if (flgMstMode) {
        Blynk.virtualWrite(btnMode, stMode);
      }
    }
    if (flgScheduleUpdate) {
      updateScheduling();
    }
    cntAuto = 0;
  } else {
    if ((stMode == modeManual) && (flgMstMode)) {
      for (idxLed = 0; idxLed < noChannel ; idxLed++) {
        if (Pin[idxLed] != 255) {
          Blynk.syncVirtual(idxLed);
        }
      }
    }
    cntAuto = 1;
  }
}

BLYNK_WRITE(languageInput) {
  lang_ter = param.asInt();
  lang = lang_ter;
  flgLanguageChange = true;
  flgSettingChange = true;
  commit_update_data();
}

BLYNK_WRITE(noiseInput) {
  flgAntiNoise_ter = param.asInt() == 1;
  flgSettingChange = true;
}

BLYNK_WRITE(btnReset) {
  if (param.asInt() == 1 && flgMstMode) {
    ESP.restart();
  }
}

void commit_update_data() {
  DynamicJsonDocument json(1024);
  json["blynk_token"]       = blynk_token_ter;
  json["blynk_server"]      = blynk_server_ter;
  json["mode_ms"]           = flgMstMode_ter;
  json["model"]             = model_ter;
  json["flgAntiNoise"]      = flgAntiNoise_ter;
  json["language"]          = lang_ter;
  json["ota_filename"]      = ota_filename_ter;
  json["noise_calib"]       = noise_calib_ter;
  json["flgBootState"]      = flgBootState_ter;
  json["flgServer"]         = flgServer_ter;
  File configFile = SPIFFS.open("/config.json", "w");
  serializeJson(json, configFile);
  configFile.close();
  if (flgLanguageChange) {
    String str_update = "Danh sách - 1.";
    String label_update[13] = {"Blue", "R-Blue", "White", "UV", "Red", "Green", "Hẹn giờ", "▲", "▼", "Thêm", "Sửa", "Xóa", "Cập nhật"};
    uint8 idxButton = 0;
    flgLanguageChange = false;
    switch (lang_ter) {
      case en:
        terminal.clear();
        terminal.println("Changing language...");
        terminal.println("Please wait for a moment");
        terminal.flush();
        str_update = "Timer List - 1.";
        label_update[tiInput] = "Time";
        label_update[btnAdd] = "Add";
        label_update[btnModify] = "Edit";
        label_update[btnDel] = "Delete";
        label_update[btnUpdate] = "Update";
        Blynk.setProperty(btnMode, "labels", "Automation", "Manual", "Setup");
        Blynk.setProperty(languageInput, "label", "Language");
        Blynk.setProperty(noiseInput, "label", "Anti-noise");
        Blynk.setProperty(languageInput, "labels", "Vietnamese", "English");
        Blynk.setProperty(btnSubmit, "onLabel", "Save");
        Blynk.setProperty(btnSubmit, "offLabel", "Save");
        Blynk.setProperty(btnReset, "onLabel", "Restart");
        Blynk.setProperty(btnReset, "offLabel", "Restart");
        Blynk.setProperty(noiseInput, "onLabel", "ON");
        Blynk.setProperty(noiseInput, "offLabel", "OFF");
        break;
      case vi:
      default:
        terminal.clear();
        terminal.println("Đang thay đổi ngôn ngữ...");
        terminal.println("Xin chờ trong vài giây");
        terminal.flush();
        Blynk.setProperty(btnMode, "labels", "Tự động", "Chỉnh tay", "Hẹn giờ");
        Blynk.setProperty(languageInput, "label", "Ngôn ngữ");
        Blynk.setProperty(noiseInput, "label", "Khử ồn");
        Blynk.setProperty(languageInput, "labels", "Tiếng Việt", "Tiếng Anh");
        Blynk.setProperty(btnSubmit, "onLabel", "Lưu");
        Blynk.setProperty(btnSubmit, "offLabel", "Lưu");
        Blynk.setProperty(btnReset, "onLabel", "Khởi động lại");
        Blynk.setProperty(btnReset, "offLabel", "Khởi động lại");
        Blynk.setProperty(noiseInput, "onLabel", "Mở");
        Blynk.setProperty(noiseInput, "offLabel", "Tắt");
        break;
    }
    str_update = str_update + String(FW_VERSION) + ".0";
    Blynk.setProperty(ter, "label", str_update);
    Blynk.setProperty(tiInput, "label", label_update[tiInput]);
    for (idxButton = 0; idxButton <= 5; idxButton++)
    {
      Blynk.setProperty(idxButton, "label", label_update[idxButton]);
    }
    for (idxButton = 9; idxButton <= 12; idxButton++)
    {
      Blynk.setProperty(idxButton,  "onLabel",       label_update[idxButton]);
      Blynk.setProperty(idxButton,  "offLabel",      label_update[idxButton]);
    }
    language_cnt = 1;
  }
  switch (lang_ter) {
    case en:
      terminal.println(F("Saved"));
      terminal.flush();
      break;
    case vi:
    default:
      terminal.println(F("Đã Lưu"));
      terminal.flush();
      break;
  }
}

BLYNK_WRITE(btnSubmit) {
  if (param.asInt() == 1 && flgMstMode && flgSettingChange) {
    commit_update_data();
    flgSettingChange = false;
  }
}

String getValue(String data, char separator, uint8 index) {
  uint8 idx = 0;
  uint8 found = 0;
  int8 strIndex[] = {0, -1};
  uint8 maxIndex = data.length()-1;

  for(idx = 0; idx <= maxIndex && found <= index; idx ++) {
    if(data.charAt(idx) == separator || idx == maxIndex) {
        found++;
        strIndex[0] = strIndex[1] + 1;
        strIndex[1] = (idx == maxIndex) ? idx + 1 : idx;
    }
  }
  return found > index ? data.substring(strIndex[0], strIndex[1]) : "";
}

BLYNK_WRITE(ter) {
  uint8 idxStt = 0;
  String label_updateapp[noChannel] = {"Blue", "R-Blue", "White", "UV", "Red", "Green"};
  String color_update[noChannel] = {"#04C0F8", "#5F7CD8", "#A9A9A9", "#945CB4", "#D3435C", "#23C48E"};
  String str_ter_low = param.asStr();
  String str_ter = param.asStr();
  str_ter_low.toLowerCase();
  if (flgMstMode) {
    if (getValue(str_ter_low,' ',0) == String("set")) {
      if (getValue(str_ter_low,' ',1) == String("lang")) {
        if (getValue(str_ter_low,' ',2) == String("en")) {
          lang_ter = en;
          lang = lang_ter;
          flgLanguageChange = true;
          flgSettingChange = true;
          terminal.println(F("Language: English"));
          terminal.flush();
        } else if (getValue(str_ter_low,' ',2) == String("vi")) {
          lang_ter = vi;
          lang = lang_ter;
          flgLanguageChange = true;
          flgSettingChange = true;
          terminal.println(F("Language: Vietnamese"));
          terminal.flush();
        }
      } else if (getValue(str_ter_low,' ',1) == String("token")) {
        getValue(str_ter,' ',2).toCharArray(blynk_token_ter,33);
        flgSettingChange = true;
        terminal.print(F("Token: "));
        terminal.println(getValue(str_ter,' ',2));
        terminal.flush();
      } else if (getValue(str_ter_low,' ',1) == String("server")) {
        getValue(str_ter_low,' ',2).toCharArray(blynk_server_ter,33);
        flgSettingChange = true;
        terminal.print(F("Server: "));
        terminal.println(getValue(str_ter,' ',2));
        terminal.flush();
      } else if (getValue(str_ter_low,' ',1) == String("noise")) {
        if(getValue(str_ter_low,' ',2) == String("on")) {
          flgAntiNoise_ter = true;
          flgSettingChange = true;
          terminal.println(F("Anti-noise on"));
          terminal.flush();
        } else if (getValue(str_ter_low,' ',2) == String("off")) {
          flgAntiNoise_ter = false;
          flgSettingChange = true;
          terminal.println(F("Anti-noise off"));
          terminal.flush();
        }
      } else if (getValue(str_ter_low,' ',1) == String("channel")) {
        if ((getValue(str_ter_low,' ',2) == String("2")) ||
            (getValue(str_ter_low,' ',2) == String("3")) ||
            (getValue(str_ter_low,' ',2) == String("4")) ||
            (getValue(str_ter_low,' ',2) == String("5")) ||
            (getValue(str_ter_low,' ',2) == String("6"))) {
          model_ter = getValue(str_ter_low,' ',2).toInt();
          flgSettingChange = true;
          terminal.print(F("Channel: "));
          terminal.println(getValue(str_ter_low,' ',2));
          terminal.flush();
        }
      } else if (getValue(str_ter_low,' ',1) == String("noise_calib")) {
        noise_calib_ter = getValue(str_ter_low,' ',2).toInt();
        flgSettingChange = true;
        terminal.print(F("Calibration: "));
        terminal.println(getValue(str_ter_low,' ',2));
        terminal.flush();
      } else if (getValue(str_ter_low,' ',1) == String("ota")) {
        getValue(str_ter,' ',2).toCharArray(ota_filename_ter,10);
        flgSettingChange = true;
        terminal.print(F("OTA file name: "));
        terminal.println(getValue(str_ter_low,' ',2));
        terminal.flush();
      } else if (getValue(str_ter_low,' ',1) == String("start")) {
        if(getValue(str_ter_low,' ',2) == String("on")) {
          flgBootState_ter = true;
          flgSettingChange = true;
          terminal.println(F("Start state is on"));
          terminal.flush();
        } else if (getValue(str_ter_low,' ',2) == String("off")) {
          flgBootState_ter = false;
          flgSettingChange = true;
          terminal.println(F("Start state is off"));
          terminal.flush();
        }
      } else if (getValue(str_ter_low,' ',1) == String("extserver")) {
        if(getValue(str_ter_low,' ',2) == String("on")) {
          flgServer_ter = true;
          flgSettingChange = true;
          terminal.println(F("External Server is on"));
          terminal.flush();
        } else if (getValue(str_ter_low,' ',2) == String("off")) {
          flgServer_ter = false;
          flgSettingChange = true;
          terminal.println(F("External Server is off"));
          terminal.flush();
        }
      }
    } else if (getValue(str_ter_low,' ',0) == String("get")) {
      if (getValue(str_ter_low,' ',1) == String("lang")) {
        if (lang_ter == en) {
          terminal.println(F("Language: English"));
          terminal.flush();
        } else if (lang_ter == vi) {
          terminal.println(F("Language: Vietnamese"));
          terminal.flush();
        }
      } else if (getValue(str_ter_low,' ',1) == String("token")) {
        terminal.print(F("Token: "));
        terminal.println(String(blynk_token_ter));
        terminal.flush();
      } else if (getValue(str_ter_low,' ',1) == String("server")) {
        terminal.print(F("Server: "));
        terminal.println(String(blynk_server_ter));
        terminal.flush();
      } else if (getValue(str_ter_low,' ',1) == String("noise")) {
        if (flgAntiNoise_ter) {
          terminal.println(F("Anti-noise on"));
          terminal.flush();
        } else {
          terminal.println(F("Anti-noise off"));
          terminal.flush();
        }
      } else if (getValue(str_ter_low,' ',1) == String("channel")) {
        terminal.print(F("Channel: "));
        terminal.println(String(model_ter));
        terminal.flush();
      } else if (getValue(str_ter_low,' ',1) == String("noise_calib")) {
        terminal.print(F("Calibration: "));
        terminal.println(String(noise_calib_ter));
        terminal.flush();
      } else if (getValue(str_ter_low,' ',1) == String("ota")) {
        terminal.print(F("OTA file name: "));
        terminal.println(String(ota_filename_ter));
        terminal.flush();
      } else if (getValue(str_ter_low,' ',1) == String("start")) {
        terminal.print(F("Start state: "));
        terminal.println(String(flgBootState_ter));
        terminal.flush();
      } else if (getValue(str_ter_low,' ',1) == String("extserver")) {
        terminal.print(F("External Server: "));
        terminal.println(String(flgServer));
        terminal.flush();
      }
      else if (getValue(str_ter_low,' ',1) == String("ssid")) {
        terminal.print(F("SSID: "));
        terminal.println(String(ssidWiFi));
        terminal.flush();
      } else if (getValue(str_ter_low,' ',1) == String("pass")) {
        terminal.print(F("Password: "));
        terminal.println(String(passWiFi));
        terminal.flush();
      }
    }
    #if (enRTC)
    else if (getValue(str_ter_low,' ',0) == String("synctime")) {
      flgRTCSync = false;
      terminal.print(F("Time synced"));
      terminal.flush();
    }
    #endif
    else if (getValue(str_ter_low,' ',0) == String("now")) {
        timeClient.update();
        terminal.print(F("Now: "));
        terminal.print(timeClient.getHours());
        terminal.print(F(":"));
        terminal.print(timeClient.getMinutes());
        terminal.print(F(":"));
        terminal.println(timeClient.getSeconds());
        #if (enRTC)
          DateTime now = rtc.now();
          terminal.print(F("Now RTC: "));
          terminal.print(now.hour());
          terminal.print(F(":"));
          terminal.print(now.minute());
          terminal.print(F(":"));
          terminal.println(now.second());
        #endif
        terminal.flush();
    } else if (getValue(str_ter_low,' ',0) == String("updateapp")) {
      for (idxStt = 0; idxStt <= 5; idxStt++) {
        Blynk.setProperty(idxStt, "label", label_updateapp[idxStt]);
        Blynk.setProperty(idxStt,  "color", color_update[idxStt]);
      }
      writeTerminal();
    } else if (getValue(str_ter_low,' ',0) == String("cls")) {
      writeTerminal();
    } else if (getValue(str_ter_low,' ',0) == String("commit")) {
      if (flgSettingChange) {
        commit_update_data();
        flgSettingChange = false;
      }
    } else if (getValue(str_ter_low,' ',0) == String("reset")) {
      ESP.restart();
    }
  }
  if (str_ter_low == String("updateall")) {
    chkFWbutton = 1;
    checkForUpdates();
  }
  if (str_ter_low == String("master")) {
    flgMstMode = true;
    flgMstMode_ter = true;
    flgSettingChange = true;
  }
}

void loop()  {
  if(Blynk.connected()) {
    Blynk.run();
  }
  wm.process();
  // server.handleClient();
  mainTimer_1s.run();
  mainTimer_20ms.run();
}
